#include "pstwo.h"
/*********************************************************     
**********************************************************/	 
#define DELAY_TIME  delay_us(5); 
u16 Handkey;	// ֵȡʱ洢
u8 Comd[2]={0x01,0x42};	//ʼ
u8 Data[9]={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; //ݴ洢
u16 MASK[]={
    PSB_SELECT,
    PSB_L3,
    PSB_R3 ,
    PSB_START,
    PSB_PAD_UP,
    PSB_PAD_RIGHT,
    PSB_PAD_DOWN,
    PSB_PAD_LEFT,
    PSB_L2,
    PSB_R2,
    PSB_L1,
    PSB_R1 ,
    PSB_GREEN,
    PSB_RED,
    PSB_BLUE,
    PSB_PINK
	};	//ֵ밴


void PS2_Init(void)
{
	RCC->APB2ENR|=1<<2;     //ʹPORTAʱ
	RCC->APB2ENR|=1<<3;     //ʹPORTBʱ
  RCC->APB2ENR|=1<<4;     //ʹPORTCʱ
	GPIOA->CRH&=0XFFF0FFFF; //PA12  
	GPIOA->CRH|=0X00030000;   

	GPIOB->CRH&=0X00FFFFFF; 
	GPIOB->CRH|=0X33000000;//PB15  B14 

	GPIOC->CRH&=0XFF0FFFFF;	//PC13ó  
	GPIOC->CRH|=0X00800000; 
//	PWR->CR|=1<<8;	//ȡд 
//	RCC->BDCR&=0xFFFFFFFE;	//ⲿر PC14PC15ΪͨIO	 	
//	BKP->CR&=0xFFFFFFFE; 	//TAMPERΪͨIOʹ 
//	PWR->CR&=0xFFFFFEFF;	//д	
}

//ֱ
void PS2_Cmd(u8 CMD)
{
	volatile u16 ref=0x01;
	Data[1] = 0;
	for(ref=0x01;ref<0x0100;ref<<=1)
	{
		if(ref&CMD)
		{
			DO_H;                   //һλλ
		}
		else DO_L;

		CLK_H;                        //ʱ
		DELAY_TIME;
		CLK_L;
		DELAY_TIME;
		CLK_H;
		if(DI)
			Data[1] = ref|Data[1];
	}
	delay_us(16);
}
//жǷΪģʽ,0x41=ģ̵ƣ0x73=ģ
//ֵ0ģʽ
//		  ģʽ
u8 PS2_RedLight(void)
{
	CS_L;
	PS2_Cmd(Comd[0]);  //ʼ
	PS2_Cmd(Comd[1]);  //
	CS_H;
	if( Data[1] == 0X73)   return 0 ;
	else return 1;

}
//ȡֱ
void PS2_ReadData(void)
{
	volatile u8 byte=0;
	volatile u16 ref=0x01;
	CS_L;
	PS2_Cmd(Comd[0]);  //ʼ
	PS2_Cmd(Comd[1]);  //
	for(byte=2;byte<9;byte++)          //ʼ
	{
		for(ref=0x01;ref<0x100;ref<<=1)
		{
			CLK_H;
			DELAY_TIME;
			CLK_L;
			DELAY_TIME;
			CLK_H;
		      if(DI)
		      Data[byte] = ref|Data[byte];
		}
        delay_us(16);
	}
	CS_H;
}

//ԶPS2ݽд,ֻ  
//ֻһʱΪ0 δΪ1
u8 PS2_DataKey()
{
	u8 index;

	PS2_ClearData();
	PS2_ReadData();

	Handkey=(Data[4]<<8)|Data[3];     //16  Ϊ0 δΪ1
	for(index=0;index<16;index++)
	{	    
		if((Handkey&(1<<(MASK[index]-1)))==0)
		return index+1;
	}
	return 0;          //ûκΰ
}

//õһҡ˵ģ	 Χ0~256
u8 PS2_AnologData(u8 button)
{
	return Data[button];
}

//ݻ
void PS2_ClearData()
{
	u8 a;
	for(a=0;a<9;a++)
		Data[a]=0x00;
}
/******************************************************
Function:    void PS2_Vibration(u8 motor1, u8 motor2)
Description: ֱ𶯺
Calls:		 void PS2_Cmd(u8 CMD);
Input: motor1:ҲС𶯵 0x00أ
	   motor2:𶯵 0x40~0xFF ֵԽ Խ
******************************************************/
void PS2_Vibration(u8 motor1, u8 motor2)
{
	CS_L;
	delay_us(16);
    PS2_Cmd(0x01);  //ʼ
	PS2_Cmd(0x42);  //
	PS2_Cmd(0X00);
	PS2_Cmd(motor1);
	PS2_Cmd(motor2);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	CS_H;
	delay_us(16);  
}
//short poll
void PS2_ShortPoll(void)
{
	CS_L;
	delay_us(16);
	PS2_Cmd(0x01);  
	PS2_Cmd(0x42);  
	PS2_Cmd(0X00);
	PS2_Cmd(0x00);
	PS2_Cmd(0x00);
	CS_H;
	delay_us(16);	
}
//
void PS2_EnterConfing(void)
{
    CS_L;
	delay_us(16);
	PS2_Cmd(0x01);  
	PS2_Cmd(0x43);  
	PS2_Cmd(0X00);
	PS2_Cmd(0x01);
	PS2_Cmd(0x00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	CS_H;
	delay_us(16);
}
//ģʽ
void PS2_TurnOnAnalogMode(void)
{
	CS_L;
	PS2_Cmd(0x01);  
	PS2_Cmd(0x44);  
	PS2_Cmd(0X00);
	PS2_Cmd(0x01); //analog=0x01;digital=0x00  ÷ģʽ
	PS2_Cmd(0x03); //Ox03ãͨMODEģʽ
				   //0xEEãͨMODEģʽ
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	PS2_Cmd(0X00);
	CS_H;
	delay_us(16);
}
//
void PS2_VibrationMode(void)
{
	CS_L;
	delay_us(16);
	PS2_Cmd(0x01);  
	PS2_Cmd(0x4D);  
	PS2_Cmd(0X00);
	PS2_Cmd(0x00);
	PS2_Cmd(0X01);
	CS_H;
	delay_us(16);	
}
//ɲ
void PS2_ExitConfing(void)
{
    CS_L;
	delay_us(16);
	PS2_Cmd(0x01);  
	PS2_Cmd(0x43);  
	PS2_Cmd(0X00);
	PS2_Cmd(0x00);
	PS2_Cmd(0x5A);
	PS2_Cmd(0x5A);
	PS2_Cmd(0x5A);
	PS2_Cmd(0x5A);
	PS2_Cmd(0x5A);
	CS_H;
	delay_us(16);
}
//ֱóʼ
void PS2_SetInit(void)
{
	PS2_ShortPoll();
	PS2_ShortPoll();
	PS2_ShortPoll();
	PS2_EnterConfing();		//ģʽ
	PS2_TurnOnAnalogMode();	//̵ơģʽѡǷ񱣴
	//PS2_VibrationMode();	//ģʽ
	PS2_ExitConfing();		//ɲ
}

















